/*-----------------------------------------------------------------------------
 * Name:    Buttons_NUCLEO_F401.c
 * Purpose: Buttons interface for NUCLEO-L152RE evaluation board
 * Rev.:    1.00
 *----------------------------------------------------------------------------*/

#include "stm32f4xx.h"                     // Device header

int32_t Buttons_Initialize (void) 
{    RCC->AHB1ENR |=  (1ul << 2);          // Povoleni hodinovho signlu pro GPIOC
     // Nastaveni vvodu PC.13 (Modre tlacitko) na vstup, bez upnut k napjen nebo zemi
     GPIOC->MODER   &= ~(3ul << 2*13);     // Vstup
     GPIOC->OSPEEDR &= ~(3ul << 2*13);     // Ruseni predchoziho stavu 
     GPIOC->OSPEEDR |=  (1ul << 2*13);     // Medium speed
     GPIOC->PUPDR   &= ~(3ul << 2*13);     // Bez upinacich odporu
     return (0);
}

uint32_t Buttons_GetState (void) 
{    if ((GPIOC->IDR & (1ul << 13)) == 0)  return(1);
     else return(0);
}

